// AOSingleDlg.cpp : implementation file
//

#include "stdafx.h"
#include "AOSingle.h"
#include "AOSingleDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CAOSingleDlg dialog

CAOSingleDlg::CAOSingleDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CAOSingleDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CAOSingleDlg)
	m_volts = 0.0f;
	m_deviceNum = 0;
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CAOSingleDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAOSingleDlg)
	DDX_Control(pDX, IDC_AOWrite, m_AOWrite);
	DDX_Text(pDX, IDC_AOVolts, m_volts);
	DDV_MinMaxFloat(pDX, m_volts, -10.f, 10.f);
	DDX_Text(pDX, IDC_DEVICENUM, m_deviceNum);
	DDV_MinMaxUInt(pDX, m_deviceNum, 0, 5);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAOSingleDlg, CDialog)
	//{{AFX_MSG_MAP(CAOSingleDlg)
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(IDC_AOWrite, OnAOWrite)
	ON_BN_CLICKED(IDC_Initialize, OnInitialize)
	ON_WM_CLOSE()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CAOSingleDlg message handlers

BOOL CAOSingleDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	// TODO: Add extra initialization here
	m_driverInstance = NULL;
	m_pSR = NULL;  // set our variables equal to something
	
	return TRUE;  // return TRUE  unless you set the focus to a control
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CAOSingleDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CAOSingleDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

void CAOSingleDlg::OnAOWrite() 
{
		
// bring in the data from the text box on the dialog
    UpdateData(TRUE); // update from the Dialog
	m_pSR->status.u.ioValue = Volts2Code(0,AO,m_volts);
// the Volts2Code function always assumes a bipolar gain of 1 is in use
// which corresponds to -10 to +10 volt range.
// when at other ranges, the Volts2Code function can not be used
// setup a single channel, polled mode AO task
	m_pSR->device = m_deviceNum;
	m_pSR->hWnd = m_hWnd;
	m_pSR->mode = POLLED;  // foreground operation
	m_pSR->operation = START; 
	m_pSR->subsystem = AO;  // use AO subsystem of board
	m_pSR->start.typeEvent = COMMAND;  // start when DriverLINX function is called
	m_pSR->stop.typeEvent = TCEVENT;   // stop automatically
	m_pSR->timing.typeEvent = NULLEVENT;  // if POLLED no timing required
	m_pSR->channels.nChannels = 1;        // only the start channel specified
	m_pSR->channels.chanGain[0].channel = 0; // use chan 0
	m_pSR->channels.chanGain[0].gainOrRange = Gain2Code(0,AO,-1);
	// -1: bipolar at gain of 1
	m_pSR->channels.numberFormat = tNATIVE;
	if (DriverLINX(m_pSR) != NoErr)  // execute the task
	{  // problem has occured
     showMessage(m_pSR);  // display the error message box
	}
	
}

void CAOSingleDlg::OnInitialize() 
{
// bring in the data from the device number text box on the dialog
    UpdateData(TRUE); // update from the Dialog

	// Open the driver and Initialize the hardware

// pass in driver name to avoid the Open DriverLINX Dialog
m_driverInstance=OpenDriverLINX(m_hWnd,"c:\\drvlinx4\\kmbdas16.dll"); 
//use kmb1800 if a DAS-1700 board, kpci3100 if KPCI-3102, etc.
m_pSR=(DL_ServiceRequest*) new (DL_ServiceRequest); //get a pointer to the service request
memset(m_pSR,0,sizeof(DL_ServiceRequest)); //Initialize the members of the service request
DL_SetServiceRequestSize(*m_pSR); //Need to set the service request size member
m_pSR->device=m_deviceNum; //should correspond to the DriverLINX Config Panel
m_pSR->operation=INITIALIZE; //Need to initialize the device before we can use it
m_pSR->subsystem=DEVICE;  //the initialize function is part of the DEVICE subsystem
m_pSR->mode=OTHER;  //Initialize is not a polled, interrupt, or dma operation, so we use OTHER
m_pSR->hWnd=m_hWnd;  //Need to set the hWnd member to the window handle of the application

if (DriverLINX(m_pSR) == NoErr)  // execute the task
{  // success
m_AOWrite.EnableWindow(TRUE);  // enable the AO Write button
}
else
{  // problem has occured
showMessage(m_pSR);  // display the error message box
}

CWnd::SetActiveWindow();   // set focus back to our dialog
}

void CAOSingleDlg::OnClose() 
{
	m_pSR->status.u.ioValue = Volts2Code(0,AO,0);
	DriverLINX(m_pSR);  //  set the output to zero on the way out

	// code to clean up after DriverLINX
	if (m_driverInstance != NULL)
	{
CloseDriverLINX(m_driverInstance); //close the DriverLINX driver
m_driverInstance=NULL; //make sure m_driverInstance isn't pointing to anything
	}
	if (m_pSR != NULL)
	{
delete(m_pSR); //de-allocate the memory used by the service request
	m_pSR=NULL;
	}
	
	CDialog::OnClose();
}

void CAOSingleDlg::showMessage(DL_ServiceRequest *SR)
{
	SR->operation=MESSAGEBOX;
	DriverLINX(SR);
	return;
}
